<?php
include 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $aluno_id         = $_POST['aluno_id'];
    $numero_processo  = $_POST['numero_processo'];
    $bi               = $_POST['bi_numero'];
    $naturalidade     = $_POST['naturalidade'];
    $data_nascimento  = $_POST['data_nascimento'];
    $local_nascimento = $_POST['bi_emissao_local'];
    $pai              = $_POST['pai'];
    $mae              = $_POST['mae'];
    $obs              = $_POST['observacoes'];
    $bi_emissao_data  = $_POST['bi_emissao_data'];

    // Verificar se já existe um termo para o aluno
    $check = $conn->prepare("SELECT id FROM termos WHERE aluno_id = ?");
    $check->bind_param("i", $aluno_id);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        // Atualizar se já existir
        $stmt = $conn->prepare("UPDATE termos SET 
            numero_processo = ?, 
            bi_numero = ?, 
            naturalidade = ?, 
            data_nascimento = ?, 
            bi_emissao_local = ?, 
            pai = ?, 
            mae = ?, 
            observacoes = ?, 
            bi_emissao_data = ?
            WHERE aluno_id = ?");

        $stmt->bind_param("sssssssssi", $numero_processo, $bi, $naturalidade, $data_nascimento, $local_nascimento, $pai, $mae, $obs, $bi_emissao_data, $aluno_id);
        $stmt->execute();
    } else {
        // Inserir novo
        $stmt = $conn->prepare("INSERT INTO termos 
            (aluno_id, numero_processo, bi_numero, naturalidade, data_nascimento, bi_emissao_local, pai, mae, observacoes, bi_emissao_data)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

        $stmt->bind_param("isssssssss", $aluno_id, $numero_processo, $bi, $naturalidade, $data_nascimento, $local_nascimento, $pai, $mae, $obs, $bi_emissao_data);
        $stmt->execute();
    }

    header("Location: preencher_termo.php?aluno_id=$aluno_id&sucesso=1");
    exit;
}
?>
